package eu.europa.ec.taxud.cesop.utils;

import javax.xml.namespace.QName;

public final class ValidationConstants {
    private ValidationConstants() {
    }

    public static final class XML {

        private XML() {
        }

        public static final String CESOP_XML_NAMESPACE_PREFIX = "cesop";
        public static final String CESOP_XML_NAMESPACE = "urn:ec.europa.eu:taxud:fiscalis:cesop:v1";
        public static final String TAG_NAME_SEPARATOR = "/";
        public static final String ATTRIBUTE_NAME_SEPARATOR = "@";

        public static final QName CESOP_QNAME = new QName(CESOP_XML_NAMESPACE, "CESOP", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName MESSAGE_SPEC_QNAME = new QName(CESOP_XML_NAMESPACE, "MessageSpec", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName TRANSMITTING_COUNTRY_QNAME = new QName(CESOP_XML_NAMESPACE, "TransmittingCountry", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName MESSAGE_TYPE_QNAME = new QName(CESOP_XML_NAMESPACE, "MessageType", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName MESSAGE_TYPE_INDIC_QNAME = new QName(CESOP_XML_NAMESPACE, "MessageTypeIndic", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName MESSAGE_REF_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "MessageRefId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName CORR_MESSAGE_REF_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "CorrMessageRefId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName REPORTING_PERIOD_QNAME = new QName(CESOP_XML_NAMESPACE, "ReportingPeriod", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName QUARTER_QNAME = new QName(CESOP_XML_NAMESPACE, "Quarter", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName YEAR_QNAME = new QName(CESOP_XML_NAMESPACE, "Year", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName TIMESTAMP_QNAME = new QName(CESOP_XML_NAMESPACE, "Timestamp", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName REPORTING_PSP_QNAME = new QName(CESOP_XML_NAMESPACE, "ReportingPSP", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName SENDING_PSP_QNAME = new QName(CESOP_XML_NAMESPACE, "SendingPSP", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName REPORTED_PAYEE_QNAME = new QName(CESOP_XML_NAMESPACE, "ReportedPayee", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName PAYMENT_DATA_BODY_QNAME = new QName(CESOP_XML_NAMESPACE, "PaymentDataBody", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName PSP_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "PSPId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName REPRESENTATIVE_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "RepresentativeId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName NAME_QNAME = new QName(CESOP_XML_NAMESPACE, "Name", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName COUNTRY_QNAME = new QName(CESOP_XML_NAMESPACE, "Country", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName ADDRESS_QNAME = new QName(CESOP_XML_NAMESPACE, "Address", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName EMAIL_ADDRESS_QNAME = new QName(CESOP_XML_NAMESPACE, "EmailAddress", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName WEBPAGE_QNAME = new QName(CESOP_XML_NAMESPACE, "WebPage", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName TAX_IDENTIFICATION_QNAME = new QName(CESOP_XML_NAMESPACE, "TAXIdentification", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName VAT_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "VATId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName TAX_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "TAXId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName ACCOUNT_IDENTIFIER_QNAME = new QName(CESOP_XML_NAMESPACE, "AccountIdentifier", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName REPRESENTATIVE_QNAME = new QName(CESOP_XML_NAMESPACE, "Representative", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName DOC_SPEC_QNAME = new QName(CESOP_XML_NAMESPACE, "DocSpec", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName REPORTED_TRANSACTION_QNAME = new QName(CESOP_XML_NAMESPACE, "ReportedTransaction", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName TRANSACTION_IDENTIFIER_QNAME = new QName(CESOP_XML_NAMESPACE, "TransactionIdentifier", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName CORR_TRANSACTION_IDENTIFIER_QNAME = new QName(CESOP_XML_NAMESPACE, "CorrTransactionIdentifier", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName DATE_TIME_QNAME = new QName(CESOP_XML_NAMESPACE, "DateTime", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName VALIDATION_RESULT_QNAME = new QName(CESOP_XML_NAMESPACE, "ValidationResult", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName VALIDATION_ERRORS_QNAME = new QName(CESOP_XML_NAMESPACE, "ValidationErrors", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName ERROR_CODE_QNAME = new QName(CESOP_XML_NAMESPACE, "ErrorCode", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName ERROR_COUNTER_QNAME = new QName(CESOP_XML_NAMESPACE, "ErrorCounter", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName ERROR_SHORT_DESC_QNAME = new QName(CESOP_XML_NAMESPACE, "ErrorShortDesc", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName ERROR_DESCRIPTION_QNAME = new QName(CESOP_XML_NAMESPACE, "ErrorDescription", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName DOC_REF_ID_QNAME = new QName(CESOP_XML_NAMESPACE, "DocRefId", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName AMOUNT_QNAME = new QName(CESOP_XML_NAMESPACE, "Amount", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName PAYMENT_METHOD_QNAME = new QName(CESOP_XML_NAMESPACE, "PaymentMethod", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName INITIATED_PHYSICAL_QNAME = new QName(CESOP_XML_NAMESPACE, "InitiatedAtPhysicalPremisesOfMerchant", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName PAYER_MS_QNAME = new QName(CESOP_XML_NAMESPACE, "PayerMS", CESOP_XML_NAMESPACE_PREFIX);
        public static final QName PSP_ROLE_QNAME = new QName(CESOP_XML_NAMESPACE, "PSPRole", CESOP_XML_NAMESPACE_PREFIX);

        public static final String TAG_NAME_PAYEE = "payee";
        public static final String TAG_NAME_PAYEE_ID = "payeeID";
        public static final String TAG_NAME_MESSAGE_ID = "messageID";
        public static final String TAG_NAME_PSP_ID = "pspID";
        public static final String TAG_NAME_REPORTING_PERIOD = "reportingPeriod";
        public static final String TAG_NAME_DOC_REF_ID = "docRefId";
        public static final String TAG_NAME_DOC_TYPE_ID = "docTypeID";
        public static final String TAG_NAME_CORR_MESSAGE_REF_ID = "corrMessageRefID";
        public static final String TAG_NAME_CORR_DOC_REF_ID = "corrDocRefID";
        public static final String TAG_NAME_ACCOUNT_ID = "accountID";
        public static final String TAG_NAME_ACCOUNT_TYPE = "accountType";
        public static final String TAG_NAME_ACCOUNT_COUNTRY = "accountCountry";
        public static final String TAG_NAME_ACCOUNT_OTHER = "accountOther";
        public static final String TAG_NAME_REPRESENTATIVE_ID = "representativeID";
        public static final String TAG_NAME_REPRESENTATIVE_TYPE = "representativeType";
        public static final String TAG_NAME_REPRESENTATIVE_OTHER = "representativeOther";
        public static final String TAG_NAME_COUNTRY = "country";
        public static final String TAG_NAME_OTHER = "other";
        public static final String TAG_NAME_NAMES = "names";
        public static final String TAG_NAME_NAME = "name";
        public static final String TAG_NAME_POSITION = "position";
        public static final String TAG_NAME_NAME_TYPE = "nameType";
        public static final String TAG_NAME_VALUE = "value";
        public static final String TAG_NAME_ADDRESSES = "addresses";
        public static final String TAG_NAME_ADDRESS = "address";
        public static final String TAG_NAME_LEGAL_TYPE = "legalType";
        public static final String TAG_NAME_STREET = "street";
        public static final String TAG_NAME_BUILDING_ID = "buildingID";
        public static final String TAG_NAME_SUITE_ID = "suiteID";
        public static final String TAG_NAME_FLOOR_ID = "floorID";
        public static final String TAG_NAME_DISTRICT = "district";
        public static final String TAG_NAME_POST_BOX = "postBox";
        public static final String TAG_NAME_POST_CODE = "postCode";
        public static final String TAG_NAME_CITY = "city";
        public static final String TAG_NAME_SUBENTITY = "subentity";
        public static final String TAG_NAME_FREE = "free";
        public static final String TAG_NAME_TAX_IDENTIFIERS = "taxIdentifiers";
        public static final String TAG_NAME_TAX_IDENTIFIER = "taxIdentifier";
        public static final String TAG_NAME_TYPE = "type";
        public static final String TAG_NAME_EMAILS = "emails";
        public static final String TAG_NAME_EMAIL = "email";
        public static final String TAG_NAME_WEBPAGES = "webpages";
        public static final String TAG_NAME_WEBPAGE = "webpage";
        public static final String TAG_NAME_REPRESENTATIVE_NAMES = "representativeNames";
        public static final String TAG_NAME_REPRESENTATIVE_NAME = "representativeName";
        public static final String TAG_NAME_METHODS = "methods";
        public static final String TAG_NAME_METHOD = "method";
        public static final String TAG_NAME_PERIOD = "period";
        public static final String TAG_NAME_OTHER_ID = "otherID";
        public static final String TAG_NAME_DESCRIPTION = "description";
        public static final String TAG_NAME_ROLES = "roles";
        public static final String TAG_NAME_ROLE = "role";
        public static final String TAG_NAME_TRANSACTIONS = "transactions";
        public static final String TAG_NAME_TRANSACTION = "transaction";
        public static final String TAG_NAME_TRANSACTION_IDENTIFIER = "transactionIdentifier";
        public static final String TAG_NAME_EXECUTION_DATE = "executionDate";
        public static final String TAG_NAME_CLEARING_DATE = "clearingDate";
        public static final String TAG_NAME_AUTHORISATION_DATE = "authorisationDate";
        public static final String TAG_NAME_PURCHASE_DATE = "purchaseDate";
        public static final String TAG_NAME_SETTLEMENT_DATE = "settlementDate";
        public static final String TAG_NAME_OTHER_DATE = "otherDate";
        public static final String TAG_NAME_OTHER_DATE_OTHER = "otherDateOther";
        public static final String TAG_NAME_AMOUNT = "amount";
        public static final String TAG_NAME_CURRENCY = "currency";
        public static final String TAG_NAME_PAYER_COUNTRY = "payerCountry";
        public static final String TAG_NAME_PAYER_ACCOUNT = "payerAccount";
        public static final String TAG_NAME_PAYMENT_TYPE = "paymentType";
        public static final String TAG_NAME_PAYMENT_TYPE_OTHER = "paymentTypeOther";
        public static final String TAG_NAME_PSP_ROLE = "pspRole";
        public static final String TAG_NAME_PSP_ROLE_OTHER = "pspRoleOther";
        public static final String TAG_NAME_PHYSICAL = "physical";
        public static final String TAG_NAME_REFUND = "refund";
        public static final String TAG_NAME_CORR_TRANSACTION = "corrTransaction";
        public static final String ATTRIBUTE_NAME_IS_REFUND = "IsRefund";
        public static final String ATTRIBUTE_NAME_PSP_ID_TYPE = "PSPIdType";
        public static final String ATTRIBUTE_NAME_PSP_ID_OTHER = "PSPIdOther";
        public static final String ATTRIBUTE_NAME_NAME_TYPE = "nameType";
        public static final String ATTRIBUTE_NAME_NAME_OTHER = "nameOther";
        public static final String ATTRIBUTE_NAME_VERSION = "version";
        public static final String TAG_NAME_ACCOUNTS = "accounts";
        public static final String TAG_NAME_ACCOUNT = "account";
    }

    public static final class KEY {

        private KEY() {
        }

        public static final String TRANSMITTING_COUNTRY_KEY = "/TransmittingCountry";
        public static final String MESSAGE_TYPE_KEY = "/MessageType";
        public static final String MESSAGE_TYPE_INDIC_KEY = "/MessageTypeIndic";
        public static final String MESSAGE_REF_ID_KEY = "/MessageRefId";
        public static final String CORR_MESSAGE_REF_ID_KEY = "/CorrMessageRefId";
        public static final String QUARTER_KEY = "/Quarter";
        public static final String YEAR_KEY = "/Year";
        public static final String TIMESTAMP_KEY = "/Timestamp";
        public static final String PSP_ID_KEY = "/PSPId";
        public static final String PSP_ID_TYPE_KEY = "/PSPId@PSPIdType";
        public static final String PSP_ID_OTHER_KEY = "/PSPId@PSPIdOther";
        public static final String REPRESENTATIVE_ID_KEY = "/RepresentativeId";
        public static final String REPRESENTATIVE_ID_TYPE_KEY = "/RepresentativeId@PSPIdType";
        public static final String REPRESENTATIVE_ID_OTHER_KEY = "/RepresentativeId@PSPIdOther";
        public static final String NAME_KEY = "/Name";
        public static final String NAME_TYPE_KEY = "/Name@nameType";
        public static final String NAME_OTHER_KEY = "/Name@nameOther";
        public static final String COUNTRY_KEY = "/Country";
        public static final String ADDRESS_LEGAL_ADDRESS_TYPE_KEY = "/Address@legalAddressType";
        public static final String ADDRESS_COUNTRY_CODE_KEY = "/Address/CountryCode";
        public static final String ADDRESS_STREET_KEY = "/Address/AddressFix/Street";
        public static final String ADDRESS_BUILDING_IDENTIFIER_KEY = "/Address/AddressFix/BuildingIdentifier";
        public static final String ADDRESS_SUITE_IDENTIFIER_KEY = "/Address/AddressFix/SuiteIdentifier";
        public static final String ADDRESS_FLOOR_IDENTIFIER_KEY = "/Address/AddressFix/FloorIdentifier";
        public static final String ADDRESS_DISTRICT_NAME_KEY = "/Address/AddressFix/DistrictName";
        public static final String ADDRESS_POB_KEY = "/Address/AddressFix/POB";
        public static final String ADDRESS_POST_CODE_KEY = "/Address/AddressFix/PostCode";
        public static final String ADDRESS_CITY_KEY = "/Address/AddressFix/City";
        public static final String ADDRESS_COUNTRY_SUBENTITY_KEY = "/Address/AddressFix/CountrySubentity";
        public static final String ADDRESS_ADDRESS_FREE_KEY = "/Address/AddressFree";
        public static final String EMAIL_ADDRESS_KEY = "/EmailAddress";
        public static final String WEB_PAGE_KEY = "/WebPage";
        public static final String VAT_ID_KEY = "/VATId";
        public static final String VAT_ID_ISSUED_BY_KEY = "/VATId@issuedBy";
        public static final String TAX_ID_KEY = "/TAXId";
        public static final String TAX_ID_ISSUED_BY_KEY = "/TAXId@issuedBy";
        public static final String TAX_ID_TYPE_KEY = "/TAXId@type";
        public static final String TAX_ID_OTHER_KEY = "/TAXId@TAXIdOther";
        public static final String ACCOUNT_IDENTIFIER_KEY = "/AccountIdentifier";
        public static final String ACCOUNT_IDENTIFIER_COUNTRY_CODE_KEY = "/AccountIdentifier@CountryCode";
        public static final String ACCOUNT_IDENTIFIER_TYPE_KEY = "/AccountIdentifier@type";
        public static final String ACCOUNT_IDENTIFIER_OTHER_KEY = "/AccountIdentifier@accountIdentifierOther";
        public static final String DOC_SPEC_DOC_TYPE_INDIC_KEY = "/DocSpec/DocTypeIndic";
        public static final String DOC_SPEC_DOC_REF_ID_KEY = "/DocSpec/DocRefId";
        public static final String DOC_SPEC_CORR_MESSAGE_REF_ID_KEY = "/DocSpec/CorrMessageRefId";
        public static final String DOC_SPEC_CORR_DOC_REF_ID_KEY = "/DocSpec/CorrDocRefId";
        public static final String TRANSACTION_IDENTIFIER_KEY = "/TransactionIdentifier";
        public static final String CORR_TRANSACTION_IDENTIFIER_KEY = "/CorrTransactionIdentifier";
        public static final String DATE_TIME_KEY = "/DateTime";
        public static final String DATE_TIME_TYPE_KEY = "/DateTime@transactionDateType";
        public static final String DATE_TIME_OTHER_KEY = "/DateTime@transactionDateOther";
        public static final String AMOUNT_KEY = "/Amount";
        public static final String AMOUNT_CURRENCY_KEY = "/Amount@currency";
        public static final String PAYMENT_METHOD_TYPE_KEY = "/PaymentMethod/PaymentMethodType";
        public static final String PAYMENT_METHOD_OTHER_KEY = "/PaymentMethod/PaymentMethodOther";
        public static final String INITIATED_PHYSICAL_KEY = "/InitiatedAtPhysicalPremisesOfMerchant";
        public static final String PAYER_MS_KEY = "/PayerMS";
        public static final String PAYER_MS_SOURCE_KEY = "/PayerMS@PayerMSSource";
        public static final String PSP_ROLE_TYPE_KEY = "/PSPRole/PSPRoleType";
        public static final String PSP_ROLE_OTHER_KEY = "/PSPRole/PSPRoleOther";
    }
}
